#ifndef PACKETBUFFER_H
#define PACKETBUFFER_H

class PacketBuffer {
public:
	PacketBuffer(const PacketBuffer *srcbuf);
	PacketBuffer(void);
	~PacketBuffer();
	void insert(unsigned long data);
	void insert(const char *data);
	void insert(const void *data, int size);
	void insertbyte(unsigned char data);
	void insertshort(unsigned short data);
	unsigned long extract(void);
	char *extract(char *databuf);
	unsigned char extractbyte(void);
	void *extract(void *databuf, int size);
	unsigned short extractlen(void);
	short extractepos(void);
	short extractipos(void);
	void clear(void);
	void resetextraction(void);
	void resetinsertion(void);
	void reset(void);
	void sendpacket(int s, char id);
	void sendpacketto(int s, char *server, unsigned short port);
	operator char *(void);
	operator int(void);
	operator +=(int size);
	operator -=(int size);
	char buffer[8192];
	short len;
	short ipos;
	short epos;
};

class BinaryPacket {
private:
	char id;
	unsigned short len;
	char data[4096];
	bool complete;

	int sendbufpos;

public:
	BinaryPacket();
	void Add(const char *szBuffer);
	void Add(void* p, int pLen);
	void Add(unsigned short val);
	void Add(unsigned int val);
	void Add(unsigned long val);
	void Add(unsigned char val);
	void GetData(char *rBuffer, int &rlen);
	char GetID();
	unsigned short GetLen();
	void Reset();
	void Query();
	void Dump(char *rBuffer, int &len);
	void SetID(char nID);
};

#endif
